/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.commands;

import emulator.EmulatorException;
import emulator.hardware.HwNumber;
import emulator.shell.DebugShell;
import emulator.shell.ShellCommand;

public class Go
implements ShellCommand {
    @Override
    public boolean execute(DebugShell shell, String[] arg) throws EmulatorException {
        if (arg.length > 1) {
            boolean valid_command = false;
            try {
                if (arg.length == 3 && arg[1].equalsIgnoreCase("til")) {
                    int target = shell.parseAddress(arg[2]);
                    shell.getCpu().stopOnceAt(new HwNumber(target));
                    valid_command = true;
                }
            }
            catch (NumberFormatException e) {
                shell.getOut().println("Illegal argument: " + e.getMessage());
            }
            if (!valid_command) {
                this.printHelp(shell);
                return false;
            }
        }
        shell.getCpu().go();
        return false;
    }

    @Override
    public void printHelp(DebugShell shell) {
        shell.getOut().println("command syntax:");
        shell.getOut().println("go               - start execution");
        shell.getOut().println("go til <address> - start execution until <address> is reached");
    }
}

